<?php 
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php wp_head(); ?>

<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-27271709-3"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-27271709-3');
</script>

<!-- Facebook Pixel Code -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window,document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '386544595100205'); 
fbq('track', 'PageView');
</script>
<noscript>
<img height="1" width="1" 
src="https://www.facebook.com/tr?id=386544595100205&ev=PageView
&noscript=1"/>
</noscript>
<!-- End Facebook Pixel Code -->

</head>

<body <?php body_class('wed'); ?>>
<div class="loader"></div>
<header>
    <div class="container-fluid top">
      <div class="container">
        <div class="row">
            <div class="col-xs-2">
              <a href="<?php echo home_url(); ?>">
               <img class="logo-crf hide" src="<?php echo get_template_directory_uri();?>/assets/files/logoscrollToFixed.png" alt="Accueil" />
              </a>
            </div>
            <div class="col-xs-10 text-right">
                <div class="newsletter inline">
                    <a href="http://carrefour-tahiti.us11.list-manage1.com/subscribe?u=e70656b51596b30fdad1206df&id=b7840ab9c7" target="_blank" class="bg-blue">
                        <span class="show-desktop">Inscrivez-vous à notre</span> <b>Newsletter</b>
                    </a>
                </div> 
                <div class="link-social inline">
                    <span class="text-social">retrouvez nous sur</span> 
                    <a title="Facebook" href="https://www.facebook.com/carrefourtahiti?fref=ts" target="_blank" class="fa-stack fa-lg social-link"><i class="fa fa-circle fa-circle-facebook fa-stack-2x"></i><i class="fa fa-facebook fa-stack-1x fa-inverse"></i></a>
                </div>
                <div id="menu-tablet" class="menu">
                    <label for="dropdownHam" id="btnHam">
                        <i class="navbar-toggle collapsed fa fa-2x fa-bars" data-toggle="collapse" data-target="#navmobile" aria-expanded="false" aria-controls="navmobile"></i>
                    </label>
                </div>
            </div>
        </div>
      </div>
    </div>
    <div id="navmobile" class="container-fluid navigation mobile collapse" aria-expanded="false" style="height:0;">
        <div class="row">
            <div class="col-lg-12">
                <?php wp_nav_menu( array(
                    'theme_location'    => 'main',
                    'container'         => 'nav-mobile',
                    'container_class'   => 'container',
                    'menu_class'        => 'btn-group-justified',
                    'container_id'      => 'navigation-mobile',
                    'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                    'walker'            => new wp_bootstrap_navwalker()
                )); ?>
	        </div>
        </div>
    </div>
    <div class="container-fluid main">
        <div class="row">
            <div class="col-lg-12">
                <?php echo do_shortcode("[metaslider id=5]"); ?>
            </div>
        </div>
    </div>
    <div class="container-fluid navigation">
        <div class="row">
            <div class="col-lg-12">
                <?php wp_nav_menu( array(
                    'theme_location'    => 'main',
                    'container'         => 'nav',
                    'container_class'   => 'container',
                    'menu_class'        => 'btn-group-justified',
                    'container_id'      => 'navigation',
                    'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                    'walker'            => new wp_bootstrap_navwalker()
                )); ?>
	        </div>
        </div>
    </div>
</header>

<div class="container wrapper">
